"use client"

import { Span } from "@/components/typeography/span"
import { Text } from "@/components/typeography/text"
import { Button } from "@/components/ui/button"
import { Popover, PopoverContent, PopoverTrigger } from "@/components/ui/popover"
import { cn } from "@/lib/utils"
import { TransformedAgency } from "@/types/transformers"
import { ComponentWithClassNameAndChildren } from "@/types/utils"
import { CaretDownIcon, CaretSortIcon, CaretUpIcon } from "@radix-ui/react-icons"
import { Column, type ColumnDef, SortingFn } from "@tanstack/react-table"
import { CircleHelp, LockKeyholeIcon } from "lucide-react"
import { AgenciesCellStatus, getStatusIcon } from "./agencies.cell-status"
import { WorkflowButtonDownload } from "./workflow.button-download"
import { WorkflowButtonStatus } from "./workflow.button-status"
import { WorkflowButtonUpload } from "./workflow.button-upload"
import { WorkflowButtonView } from "./workflow.button-view"
import { potentialDateToDateStringFormatter } from "@/lib/formatters/date-formatter"
import { AgenciesCellValidationErrors, getStatusFromPreviewAndLiveStatus } from "./agencies.cell-build"
import { AppValidationStatusOption } from "@/zod/feeds.schema"
import { Order } from "@/lib/sorting"

const INTERNAL__sortByStatus = Order.mapBy(Order.number, (a: TransformedAgency) => INTERNAL__columnSortNumberFromStatus(a.status.option));
const INTERNAL__sortById = Order.mapBy(Order.string, (a: TransformedAgency) => a.gtfsId);
const INTERNAL__sortCombined = Order.combine(INTERNAL__sortByStatus, INTERNAL__sortById)
const INTERNAL__validationErrorSortingFunction: SortingFn<TransformedAgency> = (({ original: a }, { original: b }) => {
  return INTERNAL__sortCombined(a, b)
})

export const columns: ColumnDef<TransformedAgency>[] = [
  {
    accessorKey: "agencyId",
    accessorFn: (v) => v,
    sortingFn: (({ original: a }, { original: b }) => INTERNAL__sortById(a, b)),
    header: ({ column }) => {
      return (
        <INTERNAL__SortingColumnHeader column={column}>
          Agency Id
        </INTERNAL__SortingColumnHeader>
      )
    },
    cell: ({ cell }) => {
      const { access, gtfsId, ...rest } = cell.getValue<TransformedAgency>()
      console.log('rest', access, gtfsId, rest)
      return (
        <div className="flex flex-row gap-2 items-center">
          {gtfsId}
          {access !== "ALL" && <LockKeyholeIcon className="text-muted-foreground size-3" />}
        </div>
      )
    },
  },
  {
    accessorKey: "name",
    header: "Agency Name",
  },
  {
    accessorKey: "path",
    header: "Upload Path",
  },
  {
    accessorKey: "status",
    accessorFn: (value) => value,
    header: () => {
      return (
        <p className="flex flex-row gap-0.5 items-center">
          Status{" "}
          <Popover>
            <PopoverTrigger asChild>
              <Button variant={"ghost"} size={"icon"} className="size-6"><CircleHelp className="size-3" /></Button>
            </PopoverTrigger>
            <PopoverContent className="grid gap-3">
              <Text affects={"xsmall"} className="leading-5">
                Status of feeds uploaded to both the preview and live sites.
              </Text>

              <div className="flex flex-col items-start gap-1 text-xs">
                <div className="flex flex-row gap-1.5 items-center">
                  {getStatusIcon("positive")}
                  <Text>In <Span affects={"inlinecode"}>Preview</Span> and <Span affects={"inlinecode"}>Live</Span> </Text>
                </div>

                <div className="flex flex-row gap-1.5 items-center">
                  {getStatusIcon("indeterminate")}
                  <Text>In <Span affects={"inlinecode"}>Preview</Span> but not <Span affects={"inlinecode"}>Live</Span> </Text>
                </div>

                <div className="flex flex-row gap-1.5 items-center">
                  {getStatusIcon("negative")}
                  <Text>Not in <Span affects={"inlinecode"}>Preview</Span> nor <Span affects={"inlinecode"}>Live</Span> </Text>
                </div>
              </div>
            </PopoverContent>
          </Popover>
        </p>
      )
    },
    cell: ({ cell }) => {
      return <AgenciesCellStatus cell={cell} />
    },
  },
  {
    accessorKey: "Validation Errors",
    accessorFn: (value) => value,
    sortingFn: INTERNAL__validationErrorSortingFunction,
    header: ({ column }) => {
      return (
        <p className="flex flex-row gap-0.5 items-center">
          <INTERNAL__SortingColumnHeader column={column}>
            Validation Errors{" "}
          </INTERNAL__SortingColumnHeader>
          <Popover>
            <PopoverTrigger asChild>
              <Button variant={"ghost"} size={"icon"} className="size-6"><CircleHelp className="size-3" /></Button>
            </PopoverTrigger>
            <PopoverContent className="grid gap-3">
              <Text affects={"xsmall"} className="leading-5">
                Status of any validation errors present during the agancy&apos;s last ran build.
              </Text>

              <div className="flex flex-col items-start gap-1 text-xs">
                <div className="flex flex-row gap-1.5 items-center">
                  {getStatusFromPreviewAndLiveStatus("FAILED")}
                  <Text>Validation errors were <Span affects={"inlinecode"}>present</Span>.</Text>
                </div>

                <div className="flex flex-row gap-1.5 items-center">
                  {getStatusFromPreviewAndLiveStatus(undefined)}
                  <Text>Validation errors were <Span affects={"inlinecode"}>not present</Span>.</Text>
                </div>
              </div>
            </PopoverContent>
          </Popover>
        </p>
      )
    },
    cell: ({ cell }) => {
      return <AgenciesCellValidationErrors cell={cell} />
    },
  },
  {
    accessorKey: "Uploaded Date",
    accessorFn: (v) => v.dates.uploaded,
    invertSorting: true,
    header: ({ column }) => {
      return (
        <INTERNAL__SortingColumnHeader column={column}>
          Uploaded Date
        </INTERNAL__SortingColumnHeader>
      )
    },
    cell: ({ cell }) => {
      const value = cell.getValue<Date>();
      return potentialDateToDateStringFormatter(value)
    }
  },
  {
    accessorKey: "Actions",
    accessorFn: (value) => value,
    header: () => {
      return 'Actions'
    },
    cell: ({ cell }) => {
      const value = cell.getValue<TransformedAgency>()

      return (
        <div className="flex flex-row gap-2 justify-end">
          <div className="inline-flex -space-x-px rounded-lg shadow-sm shadow-black/5 rtl:space-x-reverse">
            <WorkflowButtonView
              data={value}
              className="rounded-none shadow-none first:rounded-s-lg last:rounded-e-lg focus-visible:z-10"
            />
            <WorkflowButtonStatus
              data={value}
              className="rounded-none shadow-none first:rounded-s-lg last:rounded-e-lg focus-visible:z-10"
            />
            <WorkflowButtonUpload
              data={value}
              className="rounded-none shadow-none first:rounded-s-lg last:rounded-e-lg focus-visible:z-10"
            />
            <WorkflowButtonDownload
              data={value}
              className="rounded-none shadow-none first:rounded-s-lg last:rounded-e-lg focus-visible:z-10"
            />
          </div>

          {/* <Popover> */}
          {/*   <PopoverTrigger asChild> */}
          {/*     <Button */}
          {/*       variant={"ghost"} */}
          {/*       size={"icon"} */}
          {/*       onClick={() => { */}
          {/*         console.log("context", cell.getValue()) */}
          {/**/}
          {/*       }}> */}
          {/*       <InfoIcon className="size-3.5" /> */}
          {/*     </Button> */}
          {/*   </PopoverTrigger> */}
          {/**/}
          {/*   <PopoverContent className="w-[64rem]">{value.message}</PopoverContent> */}
          {/* </Popover> */}
        </div>
      )
    },
  },
]

function INTERNAL__SortingColumnHeader({
  column,
  className,
  children,
}: ComponentWithClassNameAndChildren<{
  column: Column<TransformedAgency>
}>) {

  return (
    <Button
      size={"sm"}
      variant={"ghost"}
      className={cn("my-0.5", className)}
      onClick={() => column.toggleSorting(column.getIsSorted() === "asc")
      }
    >
      {children}

      <INTERNAL__ColumnSortingIcon column={column} />
    </Button>
  )
}

function INTERNAL__ColumnSortingIcon({
  column
}: {
  column: Column<TransformedAgency>
}) {
  const sorted = column.getIsSorted()
  if (sorted === 'asc') {
    return <CaretUpIcon className="ml-2 size-4" />
  }

  if (sorted === 'desc') {
    return <CaretDownIcon className="ml-2 size-4" />
  }

  return <CaretSortIcon className="ml-2 size-4" />
}

function INTERNAL__columnSortNumberFromStatus(option: AppValidationStatusOption) {
  if (option === "FAILED") {
    return 0
  }

  return 10
}
